// Prints some extra information.
var extraPrints:Bool = false;

// imports \\
import Lambda;
import funkin.editors.ui.UIText;
import funkin.editors.ui.UITextBox;
import funkin.editors.ui.UIState;
import flixel.text.FlxTextFormat;
import funkin.backend.system.Logs;
importScript("data/scripts/progressionHandler");

// variables \\
var confirm:FlxSound = FlxG.sound.load(Paths.sound("menu/confirm"));
var wrong:FlxSound = FlxG.sound.load(Paths.sound("menu/codeWrong"));
var enter:FlxSound = FlxG.sound.load(Paths.sound("menu/secret/keyboard"));
var bitch:FlxSound = FlxG.sound.load(Paths.sound("menu/secret/bitch"));
var bg:FlxSprite = new FlxSprite().loadGraphic("images/menus/search/bg.png");
var logo:FlxSprite = new FlxSprite().loadGraphic("images/menus/search/logo.png");
var field:UITextBox;
var menuInput = false;

var codes:Map<String, String> = [
	"pbjt" => "peanut butter",
	"mm2wood" => "mm2funk",
	"smb3" => "tailblazer",
	"hiver" => "sadistic",
	"malleo" => "fire flowa",
	"alfred molina" => "oh my god",
	"toasters" => "smoke",
	"rosen" => "no breathing",
	"best ytp" => "sexer",
	"yee" => "important",
	"losing grasp" => "losing grap",
	"" => "aqua"
];

var supposedCode:String;

function postCreate() {
	CoolUtil.playMenuSong();
	if (extraPrints) {
		Logs.trace("There are " + Lambda.count(codes) + " codes available, them being below this trace.", 4);
		for (code => song in codes) {
			Logs.trace(code + " (goes to song: " + song + ")", 4);
		}
	}

	bg.screenCenter();
	bg.antialiasing = true;
	logo.antialiasing = true;

	add(bg);

	logo.screenCenter(FlxAxes.X);
	logo.y = 245;
	// 323.5
	add(logo);

	field = new UITextBox(278, 360, searchStateEntry, 410, 44, false);
	// field.label.size = 0;
	field.multiline = false;
	field.label.setFormat(Paths.font("vcr.ttf"), 30, 0xFF000000);
	field.caretSpr.color = FlxColor.BLACK;
	field.caretSpr.scale.set(1, 30);
	field.caretSpr.offset.set(0, -16);
	// field.caretSpr.position.set(1, 20);
	field.antialiasing = true;
	add(field);

	fieldHitbox = new FlxSprite(278, 360).makeGraphic(410, 44);
	// add(fieldHitbox);
	// fieldHitbox.color = FlxColor.RED;
	//FlxG.sound.music.play(Paths.music("freakyMenu"));
	delay = new FlxTimer().start(0.5, () -> {
		if (FlxG.save.data.unlockedDS && !FlxG.save.data.dsiPopupHappen) dsiPopup();
		menuInput = true;
	});
}

function dsiPopup() {
    FlxG.save.data.popupName = "mail";
    FlxG.save.data.dsiPopupHappen = true;
	openSubState(new ModSubState("customStates/PopupSubstate"));
	persistentUpdate = false;
	persistentDraw = true;
}

function codeDecide() {
	/*
	if (field.label.text == "") {
		Logs.trace("Search input invalid. Input is blank.", 1);
		FlxG.camera.shake(0.004, 0.3, null, true, FlxAxes.X);
		wrong.play(true);
		return;
	}else */
	if (codes[field.label.text] != null) {
		codeFound(field.label.text);
	}
	// alt. behaviour: buffer mode
	else if (field.label.text == "buffer" && !FlxG.save.data.realmode) {
		if (extraPrints) Logs.trace("Buffer mode enabled for next track.", 4);
		FlxG.save.data.realmode = true;
		FlxG.save.data.popupName = "realistic";
		openSubState(new ModSubState("customStates/PopupSubstate"));
		persistentUpdate = false;
		persistentDraw = true;
	}
	// alt. behaviour: barrel roll
	else if (field.label.text == "do a barrel roll") {
		if (FlxG.camera.angle == 0) {
			if (extraPrints) Logs.trace("Thanks, Fox.", 4);
			enter.play(true);
			FlxTween.tween(FlxG.camera, {angle: 360}, 2, {
				ease: FlxEase.sineInOut,
				onComplete: function() FlxG.camera.angle = 0
			});
		} else {
			if (extraPrints) Logs.trace("Hold your horses, bucko!", 4);
		}
	}
	// alt. behaviour: botplay toggle
	else if (field.label.text == "hacks") {
		if (FlxG.save.data.botplay_toggle) {
			FlxG.save.data.botplay_toggle = false;
			enter.play(true);
		} else {
			FlxG.save.data.botplay_toggle = true;
			FlxG.save.data.popupName = "botplay";
			openSubState(new ModSubState("customStates/PopupSubstate"));
			persistentUpdate = false;
			persistentDraw = true;
		}
		if (extraPrints) Logs.trace("Botplay is " + (FlxG.save.data.botplay_toggle ? "on" : "off") + ".", 4);
	}
	// alt behaviour: bitch.
	else if (field.label.text == "bitch") {
		bitch.play(true);
		if (extraPrints) Logs.trace("bitch.", 4);
	}
	// fallback behaviour: wrong input
	else {
		Logs.trace("Search input (" + field.label.text + ") invalid.", 1); // 1: WARNING trace
		FlxG.camera.shake(0.004, 0.3, null, true, FlxAxes.X);
		wrong.play(true);
	}
}

function codeFound(code:String) {
	Logs.trace("Search input is valid. Going to \"" + codes[code] + "\" (from entry \"" + code + "\")", 0, 10); // 0: INFORMATION trace   10: GREEN text

	// stops input, cut the music and hide the mouse
	menuInput = false;
	FlxG.mouse.visible = false;
	FlxG.sound.music.stop();

	// play the confirm sfx
	confirm.play(true);

	// "Throwing flashbang."
	FlxG.camera.flash(FlxColor.WHITE, 0.5);

	// slight cleanup.
	remove(field);

	// animation stuff
	FlxTween.tween(logo, {y: 323.5}, 1.2, {ease: FlxEase.expoOut});
	FlxTween.tween(FlxG.camera, {zoom: 1.3}, 1.8, {ease: FlxEase.quartOut});
	FlxTween.tween(FlxG.camera, {alpha: 0}, .4, {ease: FlxEase.linear, startDelay: 2});

	// set this string for when we come back
	searchStateEntry = code;

	// switch song after 2 seconds
	new FlxTimer().start(2.5, () -> {
		PlayState.loadSong(codes[code], "normal");
		fromSearchState = true;
		FlxG.switchState(new PlayState());
	});
}

function update(elapsed) {
	// hover actions
	if (FlxG.mouse.overlaps(fieldHitbox)) {
		FlxG.mouse.load(Assets.getBitmapData(Paths.image("game/cursorHover")));
	} else {
		FlxG.mouse.load(Assets.getBitmapData(Paths.image("game/cursor")));
	}

	// escape the menu
	if (menuInput && FlxG.keys.justPressed.ESCAPE) {
		skipTransition = false;
		whiteTransition = false;
		FlxG.switchState(new MainMenuState());
	}

	// confirm text entry
	if (menuInput && FlxG.keys.justPressed.ENTER) {
		skipTransition = false;
		whiteTransition = false;
		codeDecide();
	}
}
